--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;


--
-- Release Notes
-- Version : 2.6Ag 
-- Updated : 2010/07/05
--


--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET client_version='2.6Ag' WHERE read_only = 1;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='2.6Ag';


--
-- Release Notes
-- Version : B.6Ba 
-- Updated : 2010/05/12
--


--
-- Name: versionmatch; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

DROP TABLE versionmatch;

CREATE TABLE versionmatch (
    client_version character varying(16) NOT NULL,
    compatibility integer DEFAULT 0,
    read_only integer DEFAULT 0 NOT NULL,
    device_type integer DEFAULT 1 NOT NULL,
    version_key integer NOT NULL
);


ALTER TABLE public.versionmatch OWNER TO postgres;

--
-- Name: versionmatch_version_key_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE versionmatch_version_key_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.versionmatch_version_key_seq OWNER TO postgres;

--
-- Name: versionmatch_version_key_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE versionmatch_version_key_seq OWNED BY versionmatch.version_key;


--
-- Name: versionmatch_version_key_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('versionmatch_version_key_seq', 1, true);


--
-- Name: version_key; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE versionmatch ALTER COLUMN version_key SET DEFAULT nextval('versionmatch_version_key_seq'::regclass);


--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY versionmatch (client_version, compatibility, read_only, device_type) FROM stdin;
B.6Ba	1	1	1
A.0Aa	1	1	2
\.


--
-- Name: versionmatch_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY versionmatch
    ADD CONSTRAINT versionmatch_pkey PRIMARY KEY (version_key);


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='B.6Ba';


--
-- Data for Name: ucuser_profile; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE ucuser_profile ADD COLUMN os_product_name character varying(64);


--
-- Name: client_logininf; Type: VIEW; Schema: public; Owner: postgres
--

DROP VIEW client_logininf;

CREATE OR REPLACE VIEW client_logininf AS 
 SELECT userinf.user_id, userinf.first_name, ucuser_profile.os_product_name, ucuser_profile.public_ipv4_address, ucuser_profile.private_ipv4_address, ucuser_profile.using_nat, ucuser_profile.using_relay, ucuser_profile.login_date, ucuser_profile.login_time
   FROM ucuser_profile, userinf
  WHERE ucuser_profile.client_key = userinf.user_key;

ALTER TABLE versionmatch OWNER TO postgres;


--
-- Release Notes
-- Version : B.6Bb 
-- Updated : 2010/06/02
--


--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE versionmatch SET "client_version"='B.6Bb' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='A.0Ab' WHERE "read_only" = 1 AND "device_type" = 2;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='B.6Bb';


--
-- Release Notes
-- Version : 2.6Bd
-- Updated : 2010/07/09
--


--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE versionmatch SET "client_version"='2.6Bd' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='1.0Ah' WHERE "read_only" = 1 AND "device_type" = 2;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='2.6Bd';


--
-- Release Notes
-- Version : B.6Bf
-- Updated : 2011/01/13
--


--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE versionmatch SET "client_version"='B.6Bf' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='1.0Ah' WHERE "read_only" = 1 AND "device_type" = 2;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='B.6Bf';


--
-- Release Notes
-- Version : B.7Af
-- Updated : 2012/01/13
--


--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE versionmatch SET "client_version"='B.7Af' WHERE "read_only" = 1 AND "device_type" = 1;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='B.7Af';


--
-- Name: schedule_datalist; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE schedule_datalist ADD COLUMN presence_update integer DEFAULT 0;
ALTER TABLE schedule_datalist ADD COLUMN return_presence integer DEFAULT 0;


--
-- Name: loghistory_user_index; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX loghistory_user_index ON loghistory USING btree (user_key);


--
-- Name: recent_history_peer_index; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX recent_history_peer_index ON recent_history USING btree (peer_key);


--
-- Name: login_history_user_index; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX login_history_user_index ON login_history USING btree (user_key);


--
-- Name: schedule_data_add; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW schedule_data_add AS
    SELECT sch.serial_key, sch.folder_name, sch.folder_key, sch.creator_key, sch.created_dateinf, sch.created_timeinf, sch.start_dateinf, sch.start_timeinf, sch.end_dateinf, sch.end_timeinf, sch.subject, sch.schedule_location, sch.contents, sch.attendees, sch.notify_flag, sch.notify_type, sch.notify_timegap, sch.open_to_others, sch.outlook_id, sch.public_flag, sch.scenario_key, imr.destination_type, imr.destination_id, sch.recurrence_state, sch.presence_update, sch.return_presence FROM ((SELECT sd.serial_key, sf.folder_name, sd.folder_key, sd.creator_key, sd.created_dateinf, sd.created_timeinf, sd.start_dateinf, sd.start_timeinf, sd.end_dateinf, sd.end_timeinf, sd.subject, sd.schedule_location, sd.contents, sd.attendees, (sd.notify_flag)::integer AS notify_flag, sd.notify_type, sd.notify_timegap, (sd.open_to_others)::integer AS open_to_others, sd.outlook_id, (sf.public_flag)::integer AS public_flag, sd.scenario_key, sd.recurrence_state, sd.presence_update, sd.return_presence FROM schedule_datalist sd, schedule_folderlist sf WHERE (sd.folder_key = sf.serial_key)) sch LEFT JOIN imr_usergroup imr ON ((sch.scenario_key = imr.scenario_key)));


ALTER TABLE public.schedule_data_add OWNER TO postgres;

--
-- Name: get_schedule_data_add(character varying, character varying, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION get_schedule_data_add(start_day character varying, end_day character varying, creator integer) RETURNS SETOF schedule_data_add
    AS $_$DECLARE

    start_day ALIAS FOR $1;
    end_day ALIAS FOR $2;
    creator ALIAS FOR $3;
    r RECORD;
    f RECORD;
    sinf_r schedule_data_add%ROWTYPE;
    sinf_f schedule_folderlist%ROWTYPE;
    
BEGIN

    FOR f IN 
	SELECT 	* 
	FROM 	schedule_folderlist
	WHERE 	public_flag = true or (public_flag = false and creator_key = creator)
    LOOP

	    FOR r IN 
		SELECT 	* 
		FROM 	schedule_data_add
		WHERE 	folder_key = f.serial_key AND (end_dateinf::date >= start_day::date and end_day::date >= start_dateinf::date)
		LOOP
		
			sinf_r = r;
		        RETURN NEXT sinf_r; 

		END LOOP; 

    END LOOP; 

    RETURN; 

END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.get_schedule_data_add(start_day character varying, end_day character varying, creator integer) OWNER TO postgres;


--
-- Name: count_presence_member_add; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW count_presence_member_add AS
    SELECT crui.user_id, crui.first_name, crui.user_key, crui.presence_entry_count, COALESCE(presence.presence_count, (0)::bigint) AS presence_count FROM ((SELECT ui.user_id, ui.first_name, ui.user_key, cr.presence_entry_count FROM client_restriction cr, userinf ui WHERE (cr.client_key = ui.user_key)) crui LEFT JOIN (SELECT pm.owner_key, count(pm.member_key) AS presence_count FROM private_memberlist pm GROUP BY pm.owner_key) presence ON ((crui.user_key = presence.owner_key))) ORDER BY presence.presence_count DESC NULLS LAST;


ALTER TABLE public.count_presence_member_add OWNER TO postgres;

--
-- Name: get_presence_member_capability(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION get_presence_member_capability(client_key integer) RETURNS SETOF count_presence_member_add
    AS $_$DECLARE

    client_key ALIAS FOR $1;
    r RECORD;
    sinf_r count_presence_member_add%ROWTYPE;
    
BEGIN
    FOR r IN 
		SELECT *
		  FROM count_presence_member_add pc
		 WHERE pc.user_key NOT IN (SELECT owner_key
									 FROM private_memberlist pm
									WHERE pm.member_key = client_key) AND
			   pc.presence_entry_count <= pc.presence_count AND
			   pc.user_key <> client_key
    LOOP

	sinf_r = r;

    RETURN NEXT sinf_r; 

    END LOOP; 

    RETURN;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.get_presence_member_capability(client_key integer) OWNER TO postgres;


--
-- Name: register_presence_member(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION register_presence_member(client_key integer) RETURNS integer
    AS $_$DECLARE

    client_key ALIAS FOR $1;
    insert_result1 integer;
    insert_result2 integer;
    
BEGIN
	INSERT INTO private_memberlist(owner_key, member_key, presence)
         SELECT client_key AS owner_key, cr.client_key AS member_key, TRUE AS presence
           FROM client_restriction cr
          WHERE cr.client_key NOT IN (SELECT member_key
                                        FROM private_memberlist pm
                                       WHERE pm.owner_key = client_key) AND
       		    cr.client_key <> client_key;
    GET DIAGNOSTICS insert_result1 = ROW_COUNT;

	INSERT INTO private_memberlist(owner_key, member_key, presence)
          SELECT cr.client_key AS owner_key, client_key AS member_key, TRUE AS presence
            FROM client_restriction cr
           WHERE cr.client_key NOT IN (SELECT owner_key
                                         FROM private_memberlist pm
                                        WHERE pm.member_key = client_key) AND
       		     cr.client_key <> client_key;
    GET DIAGNOSTICS insert_result2 = ROW_COUNT;

    RETURN insert_result1+insert_result2; 
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.register_presence_member(client_key integer) OWNER TO postgres;


--
-- Data for Name: limitrestriction; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY limitrestriction (property, spec, limitation, minimum, descrip) FROM stdin;
141	12	1	1	Minimum Password Length
\.


--
-- Data for Name: adminlevel; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE adminlevel
   SET admin_menu='Auto Presence Registration', allowed_admin_level=1
 WHERE admin_number=117;

--
-- Data for Name: serveroamoption; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serveroamoption 
   SET data_preservation_period=12;

--
-- Data for Name: limitrestriction; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE limitrestriction SET limitation=0 WHERE property='131';

--
-- Data for Name: logoption; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE logoption SET save=0 WHERE code='1201';
UPDATE logoption SET save=0 WHERE code='1301';
UPDATE logoption SET save=0 WHERE code='1302';
UPDATE logoption SET save=0 WHERE code='1303';
UPDATE logoption SET save=0 WHERE code='1304';
UPDATE logoption SET save=0 WHERE code='1311';
UPDATE logoption SET save=0 WHERE code='1312';
UPDATE logoption SET save=0 WHERE code='1314';
UPDATE logoption SET save=0 WHERE code='1325';
UPDATE logoption SET save=0 WHERE code='1702';


--
-- Release Notes
-- Version : C.0Ab
-- Updated : 2012/03/23
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='C.0Ab' WHERE "read_only" = 1 AND "device_type" = 1;
INSERT INTO versionmatch(client_version, compatibility, read_only, device_type) VALUES ('A.0Ab', 1, 1, 3);


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='C.0Ab';


--
-- Data for Name: imr_scenario; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE imr_scenario ADD COLUMN im_always boolean DEFAULT true;
ALTER TABLE imr_scenario ADD COLUMN im_status integer DEFAULT 0;

--
-- Data for Name: icr_simple_forwarding; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE icr_simple_forwarding ADD COLUMN im_always boolean DEFAULT true;
ALTER TABLE icr_simple_forwarding ADD COLUMN im_status integer DEFAULT 0;

--
-- Data for Name: limitrestriction; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY limitrestriction (property, spec, limitation, minimum, descrip) FROM stdin;
142	1	0	0	Must Change Password at First Login
143	1	0	0	Must Change Password after Password Initialization
144	1	0	0	Do Not Allow the Same Password and User ID
145	999	0	0	Account Lockout Threshold (invalid login attempt times)
146	999	0	0	Account Lockout Duration (minutes)
147	1	0	0	Send Email When User Account is Created
148	999	3	0	Send Email Retry Count
149	999	10	0	Send Email Retry Interval When Failed (minutes)
\.

--
-- Data for Name: clientprofile; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE clientprofile ADD COLUMN account_locked boolean DEFAULT false;
ALTER TABLE clientprofile ADD COLUMN locked_duration_dateinf character varying(50);
ALTER TABLE clientprofile ADD COLUMN locked_duration_timeinf character varying(50);
ALTER TABLE clientprofile ADD COLUMN invalid_login_attempts integer DEFAULT 0;
ALTER TABLE clientprofile ADD COLUMN account_disabled boolean DEFAULT false;
ALTER TABLE clientprofile ADD COLUMN must_change_password boolean DEFAULT false;

--
-- Name: email_smtp_server; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE email_smtp_server (
    server_key integer NOT NULL,
    server_address character varying(50) NOT NULL,
    server_port_number integer DEFAULT 25 NOT NULL,
    user_id character varying(50),
    user_password character varying(50),
    use_spa integer DEFAULT 0,
    return_email_address character varying(64)
);


ALTER TABLE public.email_smtp_server OWNER TO postgres;

--
-- Name: email_smtp_server_server_key_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE email_smtp_server_server_key_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.email_smtp_server_server_key_seq OWNER TO postgres;

--
-- Name: email_smtp_server_server_key_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE email_smtp_server_server_key_seq OWNED BY email_smtp_server.server_key;


--
-- Name: email_smtp_server_server_key_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('email_smtp_server_server_key_seq', 1, false);


--
-- Name: server_key; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE email_smtp_server ALTER COLUMN server_key SET DEFAULT nextval('email_smtp_server_server_key_seq'::regclass);


--
-- Name: email_smtp_server_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY email_smtp_server
    ADD CONSTRAINT email_smtp_server_pkey PRIMARY KEY (server_key);


--
-- Name: email_useradded; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE email_useradded (
    email_key integer NOT NULL,
    email_title character varying(100),
    email_content character varying(3000),
    replace1 character varying(100),
    replace2 character varying(100),
    replace3 character varying(100),
    replace4 character varying(100)
);


ALTER TABLE public.email_useradded OWNER TO postgres;

--
-- Name: email_useradded_email_key_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE email_useradded_email_key_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.email_useradded_email_key_seq OWNER TO postgres;

--
-- Name: email_useradded_email_key_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE email_useradded_email_key_seq OWNED BY email_useradded.email_key;


--
-- Name: email_useradded_email_key_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('email_useradded_email_key_seq', 1, false);


--
-- Name: email_key; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE email_useradded ALTER COLUMN email_key SET DEFAULT nextval('email_useradded_email_key_seq'::regclass);

--
-- Name: email_useradded_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY email_useradded
    ADD CONSTRAINT email_useradded_pkey PRIMARY KEY (email_key);


--
-- Data for Name: email_useradded; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY email_useradded (email_key, email_title, email_content, replace1, replace2, replace3, replace4) FROM stdin;
1	[Notice] UCS Account Created	Dear %userName%\n\nWe are happy to announce that you are now ready to use UCS solution. \n\n* Your ID / Password\n   > "%userID%" / "%userID%" \n* UCS Client Download site\n   > http://your.ucs.server.ipaddress/ucs\n   > Please go and click "download UCS Client" link which provides you with\n        - UCS Client for PC\n        - UCS Client for Android 2.3 or later\n        - UCS Client for Windows Mobile 6.1 or 6.5\n* Security Enhancement\n   > We strongly recommend you to change your default Password for preventing  arbitrary use. \n\n\nSincerely yours\n\nUCS Administrator	\N	\N	\N	\N
\.


--
-- Name: email_sendresult; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE email_sendresult (
    result_key integer NOT NULL,
    kind integer DEFAULT 0,
    client_key integer NOT NULL,
    number_of_trial integer DEFAULT 0,
    current_state integer DEFAULT 0
);


ALTER TABLE public.email_sendresult OWNER TO postgres;

--
-- Name: email_sendresult_result_key_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE email_sendresult_result_key_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.email_sendresult_result_key_seq OWNER TO postgres;

--
-- Name: email_sendresult_result_key_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE email_sendresult_result_key_seq OWNED BY email_sendresult.result_key;


--
-- Name: email_sendresult_result_key_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('email_sendresult_result_key_seq', 1, false);


--
-- Name: result_key; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE email_sendresult ALTER COLUMN result_key SET DEFAULT nextval('email_sendresult_result_key_seq'::regclass);


--
-- Name: email_sendresult_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY email_sendresult
    ADD CONSTRAINT email_sendresult_pkey PRIMARY KEY (result_key);


--
-- Name: check_account_lockout(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION check_account_lockout("user" integer) RETURNS clientprofile
    AS $_$DECLARE

    user ALIAS FOR $1;
    lockout_threshold  limitrestriction%ROWTYPE;
    lockout_duration   limitrestriction%ROWTYPE;
    user_clientprofile clientprofile%ROWTYPE;
    
BEGIN
	SELECT * INTO lockout_threshold FROM limitrestriction WHERE property = '145';

	IF lockout_threshold.limitation <> 0 THEN
		SELECT * 
		  INTO user_clientprofile 
		  FROM clientprofile 
		 WHERE client_key = user;

		IF user_clientprofile.invalid_login_attempts < lockout_threshold.limitation THEN
			UPDATE clientprofile 
			   SET invalid_login_attempts=invalid_login_attempts+1 
			 WHERE client_key = user; 

			IF user_clientprofile.invalid_login_attempts+1 = lockout_threshold.limitation THEN
				UPDATE clientprofile 
				   SET account_locked = true 
				 WHERE client_key = user; 

				SELECT * INTO lockout_duration  FROM limitrestriction WHERE property = '146';
				
				IF lockout_duration.limitation <> 0 THEN
					UPDATE clientprofile 
					   SET locked_duration_dateinf = to_char(now() + quote_literal(lockout_duration.limitation || ' minutes')::interval, 'YYYY-MM-DD'),
					   		locked_duration_timeinf = to_char(now() + quote_literal(lockout_duration.limitation || ' minutes')::interval, 'HH24:MI:SS')
					 WHERE client_key = user; 
				ELSE
					UPDATE clientprofile 
					   SET locked_duration_dateinf = '2099-12-31',
					   		locked_duration_timeinf = '23:59:59'
					 WHERE client_key = user; 
				END IF;
			END IF;
		END IF;
	END IF;

	SELECT * 
	  INTO user_clientprofile 
	  FROM clientprofile 
	 WHERE client_key = user;

	RETURN user_clientprofile;
END;$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.check_account_lockout("user" integer) OWNER TO postgres;


--
-- Data for Name: adminlevel; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY adminlevel (admin_menu, allowed_admin_level, admin_number) FROM stdin;
E-mail Dispatch	1	318
E-mail Dispatch Result	1	319
User Security Property	1	320
\.


--
-- Release Notes
-- Version : C.0Ae
-- Updated : 2012/05/10
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='C.0Ae' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='A.0Af' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='C.0Ae';


--
-- Release Notes
-- Version : C.0Ah
-- Updated : 2012/06/18
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='C.0Ah' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='A.0Ah' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='C.0Ah';


--
-- Data for Name: email_smtp_server; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE email_smtp_server ADD COLUMN connect_type integer DEFAULT 1;

--
-- Data for Name: systeminf; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE systeminf ADD COLUMN mobile_ucs_license integer NOT NULL DEFAULT 0;

--
-- Data for Name: ucuser_profile; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE ucuser_profile ADD COLUMN client_device integer DEFAULT 1;

--
-- Release Notes
-- Version : C.0Ai
-- Updated : 2012/07/05
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='C.0Ai' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='A.0Ai' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='C.0Ai';


--
-- Name: mobile_audio_by_model; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE mobile_audio_by_model (
    model_name character varying(80) NOT NULL,
    model_description character varying(80),
    audio_setting_mode integer DEFAULT 2 NOT NULL,
    handset_enable_ns boolean DEFAULT false,
    handset_ns_mode integer DEFAULT 3 NOT NULL,
    handset_enable_agc boolean DEFAULT false,
    handset_agc_mode integer DEFAULT 3 NOT NULL,
    handset_enable_ec boolean DEFAULT true,
    handset_ec_mode integer DEFAULT 5 NOT NULL,
    handset_aecm_mode integer DEFAULT 3 NOT NULL,
    handset_aecm_enable_cng boolean DEFAULT false,
    handset_aes_mode integer DEFAULT 1 NOT NULL,
    handset_aes_saturation integer DEFAULT 28 NOT NULL,
    speaker_enable_ns boolean DEFAULT false,
    speaker_ns_mode integer DEFAULT 3 NOT NULL,
    speaker_enable_agc boolean DEFAULT false,
    speaker_agc_mode integer DEFAULT 3 NOT NULL,
    speaker_enable_ec boolean DEFAULT true,
    speaker_ec_mode integer DEFAULT 4 NOT NULL,
    speaker_aecm_mode integer DEFAULT 3 NOT NULL,
    speaker_aecm_enable_cng boolean DEFAULT false,
    speaker_aes_mode integer DEFAULT 2 NOT NULL,
    speaker_aes_saturation integer DEFAULT 28 NOT NULL
);


ALTER TABLE public.mobile_audio_by_model OWNER TO postgres;

--
-- Name: mobile_audio_by_model_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY mobile_audio_by_model
    ADD CONSTRAINT mobile_audio_by_model_pkey PRIMARY KEY (model_name);


--
-- Name: mobile_audio_by_client; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE mobile_audio_by_client (
    client_key integer NOT NULL,
    audio_setting_mode integer DEFAULT 2 NOT NULL,
    handset_enable_ns boolean DEFAULT false,
    handset_ns_mode integer DEFAULT 3 NOT NULL,
    handset_enable_agc boolean DEFAULT false,
    handset_agc_mode integer DEFAULT 3 NOT NULL,
    handset_enable_ec boolean DEFAULT true,
    handset_ec_mode integer DEFAULT 5 NOT NULL,
    handset_aecm_mode integer DEFAULT 3 NOT NULL,
    handset_aecm_enable_cng boolean DEFAULT false,
    handset_aes_mode integer DEFAULT 1 NOT NULL,
    handset_aes_saturation integer DEFAULT 28 NOT NULL,
    speaker_enable_ns boolean DEFAULT false,
    speaker_ns_mode integer DEFAULT 3 NOT NULL,
    speaker_enable_agc boolean DEFAULT false,
    speaker_agc_mode integer DEFAULT 3 NOT NULL,
    speaker_enable_ec boolean DEFAULT true,
    speaker_ec_mode integer DEFAULT 4 NOT NULL,
    speaker_aecm_mode integer DEFAULT 3 NOT NULL,
    speaker_aecm_enable_cng boolean DEFAULT false,
    speaker_aes_mode integer DEFAULT 2 NOT NULL,
    speaker_aes_saturation integer DEFAULT 28 NOT NULL
);


ALTER TABLE public.mobile_audio_by_client OWNER TO postgres;

--
-- Name: mobile_audio_by_client_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY mobile_audio_by_client
    ADD CONSTRAINT mobile_audio_by_client_pkey PRIMARY KEY (client_key);


--
-- Name: make_mobile_audio_by_client(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION make_mobile_audio_by_client()
  RETURNS integer AS
$BODY$DECLARE
    u RECORD;
    t RECORD;
BEGIN
    FOR u IN 
	SELECT 	user_key
	FROM 	userinf
	WHERE   user_key <> 1 AND user_id <> '' AND user_id IS NOT NULL
	LOOP
		INSERT INTO mobile_audio_by_client(client_key)
		    VALUES (u.user_key);
    END LOOP; 
    RETURN 1; 
END;$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100;
ALTER FUNCTION make_mobile_audio_by_client() OWNER TO postgres;

SELECT * FROM make_mobile_audio_by_client();

--
-- Data for Name: ucuser_profile; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE ucuser_profile ADD COLUMN model_name character varying(80);


--
-- Data for Name: adminlevel; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY adminlevel (admin_menu, allowed_admin_level, admin_number) FROM stdin;
Audio Setting by Mobile Client	1	321
Audio Setting by Mobile Phone	1	322
\.


--
-- Name: create_audio_setting_by_mobile_phone(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE OR REPLACE FUNCTION create_audio_setting_by_mobile_phone()
  RETURNS integer AS
$BODY$DECLARE
    u RECORD;
    t RECORD;
BEGIN
    FOR u IN 
		SELECT DISTINCT model_name 
		FROM   ucuser_profile 
		WHERE  model_name IS NOT NULL AND 
			   model_name NOT IN ( SELECT model_name FROM mobile_audio_by_model )
		LOOP
			INSERT INTO mobile_audio_by_model(model_name, model_description)
				VALUES (u.model_name, u.model_name);
		END LOOP; 
    RETURN 1; 
END;$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100;
ALTER FUNCTION create_audio_setting_by_mobile_phone() OWNER TO postgres;

--
-- Release Notes
-- Version : 3.0Aj
-- Updated : 2012/07/09
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='3.0Aj' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='1.0Aj' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='3.0Aj';


--
-- Release Notes
-- Version : 3.0Ak
-- Updated : 2012/08/15
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='3.0Ak' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='1.0Ak' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='3.0Ak';


--
-- Data for Name: serveroamoption; Type: TABLE DATA; Schema: public; Owner: postgres
--

ALTER TABLE serveroamoption ADD COLUMN on_demand_backup_request boolean DEFAULT false;


--
-- Release Notes
-- Version : 3.0Am
-- Updated : 2012/09/07
--

--
-- Data for Name: versionmatch; Type: TABLE DATA; Schema: public; Owner: postgres
--

DELETE FROM versionmatch WHERE read_only = 0;

UPDATE versionmatch SET "client_version"='3.0Am' WHERE "read_only" = 1 AND "device_type" = 1;
UPDATE versionmatch SET "client_version"='1.0Am' WHERE "read_only" = 1 AND "device_type" = 3;


--
-- Data for Name: serverinf; Type: TABLE DATA; Schema: public; Owner: postgres
--

UPDATE serverinf SET "version"='3.0Am';


--
-- PostgreSQL database dump complete
--